<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS - Generate Test Cases";
//$page_breadcrumb = "Generate Test Cases";
$page_breadcrumb = "Generate Test Cases &amp; Start Testing (1 of 2)";
//$page_h1 = "Generate Test Cases &amp; Start Testing (1 of 2)";
$page_h1 = "Selecting the Features of the String Search Tool to Test";
//$isSsHome = 1; // setting this variable will help ft_ss_head.php in rendering the page as we call it next...
include "ft_ss_need_logs.php";
include_once('../include/ss-global.php');

if ($ftlogs_mounted == 1) { // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.

	// If the user has already completed this page and is just coming back to make a change, pull back 
	// their previous selections from ss-config.txt so we can autofill the form with their previous selections

	$path = is_ftlogs_mounted(FALSE);
	
	$filename = "ss-config.txt";
		
	// does ss-config.txt config file exist?
	if (file_exists($path."/".$filename)){ 
		// try to read config file
		$testconfiglines = file($path."/".$filename);
		if ($testconfiglines !== false){ // read of config file was successful!
			// initialize...
			$toolname = "";
			$toolversion = "";
			$se_other_name = "";
			$engines_to_test = array();
			$datasets = array();
			$testcases = array();	
			// $blockerinfo = get_blocker_info($handle);

			// get toolname and toolversion from hwb-config.txt file
			foreach ($testconfiglines as $line){
				if(strpos($line, "toolname") !== false){
					$line_exploded = explode(" ", trim($line));
					$toolname = implode(" ", array_slice($line_exploded, 1));
				} else if(strpos($line, "toolversion") !== false){
					$line_exploded = explode(" ", trim($line));
					$toolversion = implode(" ", array_slice($line_exploded, 1));
				} else if (strpos($line, "se_other_name") !== false){
					$line_exploded = explode(" ", trim($line));
					$se_other_name = implode(" ", array_slice($line_exploded, 1));
				} else if(strpos($line, "engines") !== false){ 
					$line_exploded = explode(" ", trim($line));
					$engines_to_test = array_slice($line_exploded, 1);
				} else if(strpos($line, "datasets") !== false){ 
					    $line_exploded = explode(" ", trim($line));
					    $datasets = array_slice($line_exploded, 1);
				} else if(strpos($line, "FT-SS") !== false){
					$line_exploded = explode("-", trim($line));
					$testcases[] = trim($line);
				}	
			}
		} else { // read of hwb-config.txt failed for some reason
			echo "<p><b>Error:</b> error opening ".$path."/".$filename.".</p>";				
			$continue = 0;
		}
	}	

?>
<p>Use this page to select the features of the tool you want to test.   

<p>You need to specify the following:
<ol>
	<li>The name and version of the tool</li>
	<li>The search engines you want to test</li>
	<li>The data sets you want to test</li>
   <li>The features you want to test the tool for <!--<b>Select <u>only</u> 
the features you want to test your tool for.</b>--></li> 
</ol>
</p><br>

<form method="POST" action="savetestconfigfile.php"> 
<h2 style="font-size:1.7em; color:#008000"><b>1 Tool Name and Version</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
	<!--<p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->
	<p>
<?php	
echo 'Enter the tool name: &nbsp;&nbsp;&nbsp;&nbsp;<input name="toolname" type="text" size="35" required value="'.$toolname.'"><br> ';
echo 'Enter the tool version: &nbsp;<input name="toolversion" type="text" size="35" required value="'.$toolversion.'"><br>';
?>
	</p>
</div><br>
	
<h2 style="font-size:1.7em; color:green"><b>2 Search Engines to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->

<p>A search tool may have more than one search engine that can be used. Usually this is
a choice between a live search (Scans the data set for a match to a target) or an indexed
search (before doing any searching the data set is scanned and an index is built so that
a search is just a look up in the index).</p>

<p>Select the search engines that you want to test for the tool.<br>

<?php
foreach($engines_dict as $key => $value){
	if (in_array($key, $engines_to_test)){ // check if the user selected this search engine the last time they were on this page
		echo '<input name="engines[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';		
	} else { // user did not select this engine (or they haven't been to this page yet)
		echo '<input name="engines[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
	
echo '</p><p>If Other is selected, enter the other search engine name:&nbsp; <input name="se_other_name" type="text" value="'.$se_other_name.'"></p>';
?>
	</div><br>

<h2 style="font-size:1.7em; color:green"><b>3 Data Sets to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->
<p>There are two test data sets that can be downloaded to test 
a search tool. The Windows based data set has three formatted
partitions (FAT32, ExFAT and NTFS), a unformatted partition and
some strings in locations unreachable by normal file system access.
The second test image has three UNIX-like formatted partitions (OSX Journaled,
OSX Case Sensitive, APFS (Apple File System) and Linux ext4).</p>

<p>Select the data sets that you want to test for the tool.<br>
<?php // print out a list of the data sets that can be selected
foreach($datasets_dict as $key => $value){
	if (in_array($key, $datasets)){ // check if the user selected this data set the last time they were on this page
		echo '<input name="datasets[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this data set (or they haven't been to this page yet)
		echo '<input name="datasets[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
?>	
</p>
</div><br>

<h2 style="font-size:1.7em; color:green"><b>4 Tool Features to Test</b><br></h2>
      <p>Select the tool features you want to test. Click <a href="readmehelp.php#testcases">here</a> to see the full descriptions of the test cases that the features listed below map to.<!--<span style="color:red;"><b>SELECT <u>ONLY</u> 
    	THE FEATURES YOU WANT TO TEST THE TOOL FOR.</b></span>--><br></p>
    
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Basic Search Features</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
        url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!--		<p><input name="basic[]" value="ft-ss-01" type="checkbox"> &nbsp;Simple search. Test that the tool can find a single ASCII string.<br> 
        <input name="basic[]" value="ft-ss-02" type="checkbox"> &nbsp;Substring match and ignore case. Test the substring match and ignore case features of the tool.<br> 
        <input name="basic[]" value="ft-ss-03" type="checkbox"> &nbsp;Whole word search. Test searching for a whole word match vs a substring match.</p>-->

		<p>In this section, select the basic string search features you want to test for the tool. At a minimum, you should consider testing the basic features you use in your lab.</p>

		<p>What basic string search features do you want to test?</p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // print out a list of the "basic" test cases
foreach($basic_dict_extended as $key => $value){
	$checked = 0; // false
	if ($key == "FT-SS-02a" || $key == "FT-SS-02b") { // FT-SS-02a and FT-SS-02b map to FT-SS-02
		if (in_array("FT-SS-02", $testcases)){
			$checked = 1;
		}
	} else if (in_array($key, $testcases)){ // check if the user selected this data set the last time they were on this page
		$checked = 1;
	}
	
	if ($checked){ // the user selected this data set the last time they were on this page
		echo '<input name="basic[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this data set (or they haven't been to this page yet)
		echo '<input name="basic[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
?>
		</p>
	</div><br>  
		
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Logical Combinations</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of logical combinations you want to test for the 
		tool. At a minimum, you should consider testing the types of logical combinations you use in your lab.</p>

        <p>What logical combinations do you want to test?</p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // logical combination test cases
foreach($logical_dict as $key => $value){
	if (in_array($key, $testcases)){ // check if the user selected this test case the last time they were on this page
		echo '<input name="logical[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this test case (or they haven't been to this page yet)
		echo '<input name="logical[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
?>
		</p>		
    </div><br>

    <h3 style="font-size:1.6em; color:#9D0F19"><b>Search Unicode Character Classes</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of Unicode searches you want to test for the tool. At a minimum, you should consider testing the types of Unicode searches you use your lab.</p>
		
        <p>What types of Unicode searches do you want to test?</p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // unicode 
foreach($unicode_dict as $key => $value){
	if (in_array($key, $testcases)){ // check if the user selected this test case the last time they were on this page
		echo '<input name="unicode[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this test case (or they haven't been to this page yet)
		echo '<input name="unicode[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}		
?>
		</p>
    </div><br>
	
<!--	  <h2 style="font-size:1.6em">Operations on Partitions</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Search Tool Defined Queries</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of tool pre-defined queries you want to test for the tool. At a minimum, 
		you should consider testing the types of pre-defined queries you use in your lab.</p>        

        <p>What tool pre-defined queries do you want to test? </p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // pre-defined queries 
foreach($tool_defined_dict as $key => $value){
	if (in_array($key, $testcases)){ // check if the user selected this test case the last time they were on this page
		echo '<input name="tool_defined[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this test case (or they haven't been to this page yet)
		echo '<input name="tool_defined[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
?>			
		</p>
	</div><br>

<!--      <h2 style="font-size:1.6em">Error Condition Tests</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Special Cases</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the special situations you want to test for the tool.</p>
		
        <p>What special situations do you want to test? </p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // special
foreach($special_dict as $key => $value){
	echo '<input name="special[]" value="'.$key.'" type="checkbox"';
	if (in_array($key, $testcases)){ // check if the user selected this test case the last time they were on this page
		echo ' checked';
	} 			
	echo '>&nbsp; ';
	if (in_array($key, $ignore_for_unix)){ //
		echo '<b>*</b>';
	}
	echo $value.' <br>';	
}	
?>		
		</p><p><b>*</b>Note: some tests are only available for the Windows data set.</p>
		
	</div><br>

<!--      <h2 style="font-size:1.6em">Hash Operations and Hashes</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Regular Expressions</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

		<p>In this section, select the types of regular expression searches you want 
        to test for the tool. You should consider testing the tool for the types of 
        regular expression searches you use the tool for in your lab.</p>

        <p>What regular expression searches do you want to test? </p>
		<p style="margin-top: -1em; margin-bottom: 0.3em;"><a href="">Test all</a>&nbsp;&nbsp;/&nbsp; <a href="">Don't test</a></p>
		<p>
<?php // regular expressions
foreach($regex_dict as $key => $value){
	if (in_array($key, $testcases)){ // check if the user selected this test case the last time they were on this page
		echo '<input name="regex[]" value="'.$key.'" type="checkbox" checked>&nbsp; '.$value.' <br>';
	} else {  // user did not select this test case (or they haven't been to this page yet)
		echo '<input name="regex[]" value="'.$key.'" type="checkbox">&nbsp; '.$value.' <br>';
	}
}	
?>		
		</p>
</div><br>
	
	
&nbsp;&nbsp;&nbsp;&nbsp;<input value="Next" type="submit">         
</form>
</p>

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<?php
}  // endif($ftlogs_mounted==1)
include "ft_ss_tail.php";
?>

